Attribute VB_Name = "Lines"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Sub menuLinePointToPoint()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim line1 As aLine
Set line1 = cfobject.CreateLine(-0.1, -0.1, 0.1, -0.1)

Dim line2 As aLine
Set line2 = cfobject.CreateLine(-0.1, 0.1, 0.1, 0.1)

api.CommitCalls "CreateLine", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineStartToStart()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetCount = 2) Then
    
    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
            Set line1 = cfobject.CreateLineStartToStart(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineStartToStart", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineStartToMiddle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then

    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
           Set line1 = cfobject.CreateLineStartToMiddle(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineStartToMiddle", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineStartToEnd()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then
    
    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
          Set line1 = cfobject.CreateLineStartToEnd(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineStartToEnd", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineMiddleToStart()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then

    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
           Set line1 = cfobject.CreateLineMiddleToStart(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineMiddleToStart", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineMiddleToMiddle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then
    
    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
            Set line1 = cfobject.CreateLineMiddleToMiddle(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineMiddleToMiddle", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineMiddleToEnd()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then
    
    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
        Set line1 = cfobject.CreateLineMiddleToEnd(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineMiddleToEnd", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineEndToStart()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then

    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
           Set line1 = cfobject.CreateLineEndToStart(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineEndToStart", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineEndToMiddle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then
    
    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
           Set line1 = cfobject.CreateLineEndToMiddle(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineEndToMiddle", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuLineEndToEnd()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

Dim lineSetIt As Iterator
Set lineSetIt = prod.GetClass("It").CreateAObjectIt(objset)

If (objset.GetCount = 2) Then

    Dim obj1 As aLine
    Dim obj2 As aLine
    Set obj1 = lineSetIt.start
    Set obj2 = lineSetIt.Next
    
    If (obj1.IsA("Line") And obj2.IsA("Line")) Then
        If (obj1.GetGeometricForm.IsA("Straight") And obj2.GetGeometricForm.IsA("Straight")) Then
         Set line1 = cfobject.CreateLineEndToEnd(obj1, obj2)
        Else
            MsgBox "Two Straight Lines not Selected"
        End If
    Else
        MsgBox "Selected entities are not Lines"
    End If
Else
    MsgBox "More than two lines selected"
End If

api.CommitCalls "CreateLineEndToEnd", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuCircle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim circle1 As aLine
Set circle1 = cfobject.CreateCircle(0, 0, 0.05)

api.CommitCalls "CreateCircle", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub


Sub menuRectangle()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim rectObjectSet As ObjectSet
Set rectObjectSet = cfobject.CreateRectangle(-0.125, -0.125, 0.125, 0.125)

api.CommitCalls "CreateRectangle", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuArc()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim wp As aWorkplane
Set wp = activePart.GetActiveWorkplane

Dim startPoint As aPoint
Dim endPoint As aPoint
Dim center As aPoint

Set startvec = prod.GetClass("Vector").CreateVector(0.1, 0, 0)
Set endvec = prod.GetClass("Vector").CreateVector(-0.1, 0, 0)
Set centerVec = prod.GetClass("Vector").CreateVector(0, 0, 0)

Set startPoint = prod.GetClass("Point").CreatePoint(wp.Get3DVector(startvec))
Set endPoint = prod.GetClass("Point").CreatePoint(wp.Get3DVector(endvec))
Set center = prod.GetClass("Point").CreatePoint(wp.Get3DVector(centerVec))

Dim arc As aLine
Set arc = cfobject.CreateArcStartEndCenter(startPoint, endPoint, center)

api.CommitCalls "CreateArcStartEndCenter", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

